<?php
/**
 * OceanWP Customizer Class
 *
 * @package OceanWP WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function ocean_customizer_section_icons() {

	$icons = array(
		'header' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cchi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<path class="cchi-1" d="M27.0029296875,29.7006591101H4.9970703125c-1.4868164062,0-2.6967773438-1.2099609375-2.6967773438-2.697265625V4.9965575476c0-1.4873046875,1.2099609375-2.697265625,2.6967773438-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.0068359375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9970703125,4.1000731726c-.4946289062,0-.8969726562.40234375-.8969726562.896484375v22.0068359375c0,.494140625.40234375.896484375.8969726562.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9965575476c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9970703125Z"/>
				<path class="cchi-1" d="M28.7998046875,8.0864012976H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="cchi-1" d="M28.7998046875,12.0727294226H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="cchi-1" x="3.2179539328" y="6.9203028391" width="25.5640921345" height="3.986044088"/>
			</svg>',

		'topbar' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cctbi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<path class="cctbi-1" d="M27.0029296875,29.7000805971H4.9970703125c-1.4868164062,0-2.6967773438-1.2099609375-2.6967773438-2.697265625V4.9969555971c0-1.4873046875,1.2099609375-2.697265625,2.6967773438-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9970703125,4.1004712221c-.4946289062,0-.8969726562.40234375-.8969726562.896484375v22.005859375c0,.494140625.40234375.896484375.8969726562.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9969555971c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9970703125Z"/>
				<path class="cctbi-1" d="M28.7998046875,8.0867993471H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="cctbi-1" d="M28.7998046875,12.0721509096H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="cctbi-1" x="3.2179539328" y="3.4286219622" width="25.5640921345" height="3.986044088"/>
			</svg>',

		'blog' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cbi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="cbi-1" d="M27.0029296875,29.7000291617H4.9970703125c-1.4868164062,0-2.6967773438-1.2099609375-2.6967773438-2.697265625V4.9969041617c0-1.4873046875,1.2099609375-2.697265625,2.6967773438-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9970703125,4.1004197867c-.4946289062,0-.8969726562.40234375-.8969726562.896484375v22.005859375c0,.494140625.40234375.896484375.8969726562.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9969041617c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9970703125Z"/>
				<path class="cbi-1" d="M28.7998046875,7.3006150992H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="cbi-1" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
				</g>
				<g>
				<g>
					<path class="cbi-1" d="M10.11328125,23.4051072867c-.349609375,0-.689453125-.1376953125-.9467773438-.39453125-.3618164062-.3623046875-.4858398438-.888671875-.32421875-1.373046875l.5634765625-1.6904296875c.2329101562-.697265625.6303710938-1.341796875,1.150390625-1.861328125l8.4057617188-8.40625c.3515625-.3515625.921875-.3515625,1.2734375,0l2.2626953125,2.2626953125c.3515625.3515625.3515625.921875,0,1.2734375l-8.4067382812,8.40625c-.5190429688.51953125-1.1625976562.91796875-1.861328125,1.150390625l-1.689453125.5625c-.140625.046875-.2846679688.0703125-.4272460938.0703125ZM19.5986328125,11.5887010367l-7.7700195312,7.7705078125c-.3227539062.322265625-.5703125.7236328125-.71484375,1.1572265625l-.2744140625.822265625.822265625-.2734375c.43359375-.14453125.8334960938-.392578125,1.15625-.7158203125l7.7709960938-7.7705078125-.990234375-.990234375Z"/>
					<path class="cbi-1" d="M21.8583984375,13.4822557242c-.23046875,0-.4609375-.0888671875-.63671875-.2646484375-.3515625-.3515625-.3505859375-.921875.0009765625-1.2724609375.1318359375-.1318359375.2041015625-.3076171875.2041015625-.494140625,0-.1875-.072265625-.36328125-.205078125-.4951171875-.2724609375-.2744140625-.7177734375-.2724609375-.990234375,0-.3515625.3515625-.9208984375.3505859375-1.2724609375-.0009765625s-.3505859375-.921875.0009765625-1.2724609375c.9736328125-.97265625,2.55859375-.9736328125,3.5341796875,0,.47265625.47265625.7333984375,1.1005859375.7333984375,1.7685546875s-.2607421875,1.2958984375-.7333984375,1.767578125c-.17578125.17578125-.4052734375.263671875-.6357421875.263671875Z"/>
				</g>
				<path class="cbi-1" d="M20.4736328125,26.3230760367h-12.4736328125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h12.4736328125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<circle class="cbi-1" cx="24.0781357298" cy="25.4228742966" r=".9"/>
				</g>
			</svg>',

		'typo' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cctypoi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="cctypoi-1" d="M10.8134765625,28.5024742922c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-5.0498046875c0-.4970703125.4028320312-.900390625.8999023438-.900390625s.8999023438.4033203125.8999023438.900390625v5.0498046875c0,.4970703125-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="cctypoi-1" d="M7.4072265625,25.9770836672h-2.8647460938c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h2.8647460938c.4970703125,0,.8999023438.4033203125.8999023438.900390625s-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="cctypoi-1" d="M27.45703125,25.9770836672H10.8178710938c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h16.6391601562c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				<g>
				<g>
					<path class="cctypoi-1" d="M15.755859375,15.9380211672H5.5209960938c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h10.2348632812c.4970703125,0,.8999023438.4033203125.8999023438.900390625s-.4028320312.900390625-.8999023438.900390625Z"/>
					<path class="cctypoi-1" d="M18.0732421875,21.3462242922c-.3486328125,0-.681640625-.205078125-.8271484375-.5458984375l-6.6455078125-15.525390625-6.5727539062,15.525390625c-.1962890625.4560546875-.724609375.669921875-1.181640625.47265625-.45703125-.1953125-.6689453125-.724609375-.4736328125-1.181640625l6.6450195312-15.525390625c.2778320312-.6484375.9130859375-1.0673828125,1.6186523438-1.0673828125h.0004882812c.7055664062,0,1.3408203125.4189453125,1.6186523438,1.0673828125l6.6450195312,15.525390625c.1962890625.45703125-.015625.986328125-.47265625,1.181640625-.1162109375.0498046875-.236328125.0732421875-.3544921875.0732421875Z"/>
				</g>
				<path class="cctypoi-1" d="M26.111328125,21.3501305422h-3.8134765625c-1.0126953125,0-1.8369140625-.830078125-1.8369140625-1.8505859375v-3.2841796875c0-.9833984375.7939453125-1.783203125,1.76953125-1.783203125h5.6689453125v-2.9140625l-5.6015625-.0498046875-.0361328125,1.2578125c0,.4970703125-.4033203125.900390625-.900390625.900390625s-.900390625-.4033203125-.900390625-.900390625v-1.2080078125c0-1.0205078125.82421875-1.8505859375,1.8369140625-1.8505859375h5.5654296875c1.0126953125,0,1.8369140625.830078125,1.8369140625,1.8505859375v3.814453125c0,.4970703125-.4033203125.900390625-.900390625.900390625h-6.5693359375l.03125,3.2666015625,3.849609375.0498046875c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="cctypoi-1" d="M28.7998046875,21.3501305422c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625v-5.1171875c0-.4970703125.4033203125-.900390625.900390625-.900390625s.900390625.4033203125.900390625.900390625v5.1171875c0,.4970703125-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
			</svg>',

		'color' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cci-1 {
					fill: #fff;
					font-family: MyriadPro-Regular, \'Myriad Pro\';
					font-size: 3.5399999619px;
					}

					.cci-2 {
					letter-spacing: -.0110346046em;
					}

					.cci-3 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<text class="cci-1" transform="translate(-.0034923553 -.814612295)"><tspan class="cci-2" x="0" y="0">C</tspan><tspan x="2.0141601562" y="0">olors</tspan></text>
				<g>
				<path class="cci-3" d="M18.91015625,19.5499278051c-.1376953125,0-.275390625-.0322265625-.4013671875-.0947265625-.2275390625-.11328125-.396484375-.318359375-.4658203125-.5634765625-.3525390625-1.263671875-1.0693359375-2.421875-2.0454101562-3.322265625-.970703125.8916015625-1.685546875,2.048828125-2.041015625,3.322265625-.068359375.2451171875-.2368164062.44921875-.4643554688.5625-.228515625.1142578125-.4931640625.1259765625-.7294921875.0341796875-2.5942382812-1.0126953125-4.5903320312-3.216796875-5.3393554688-5.896484375-.2143554688-.767578125-.3232421875-1.572265625-.3232421875-2.3916015625,0-4.9072265625,3.9921875-8.900390625,8.8999023438-8.900390625,4.9072265625,0,8.900390625,3.9931640625,8.900390625,8.900390625,0,.8212890625-.109375,1.6259765625-.32421875,2.392578125-.7470703125,2.673828125-2.7431640625,4.8779296875-5.337890625,5.89453125-.10546875.0419921875-.216796875.0625-.328125.0625ZM16,4.1007090551c-3.9150390625,0-7.1000976562,3.1845703125-7.1000976562,7.099609375,0,.6552734375.0864257812,1.296875.2568359375,1.9072265625.5131835938,1.833984375,1.7587890625,3.3896484375,3.41015625,4.3046875.6088867188-1.4736328125,1.6127929688-2.7744140625,2.8940429688-3.7333984375.3203125-.240234375.76171875-.23828125,1.08203125.0029296875,1.2802734375.9677734375,2.2822265625,2.267578125,2.888671875,3.7294921875,1.6533203125-.9169921875,2.8994140625-2.47265625,3.4111328125-4.3037109375.1708984375-.6083984375.2568359375-1.25.2568359375-1.9072265625,0-3.9150390625-3.1845703125-7.099609375-7.099609375-7.099609375Z"/>
				<path class="cci-3" d="M11.2001953125,29.7003184301c-4.9077148438,0-8.8999023438-3.9931640625-8.8999023438-8.900390625,0-3.638671875,2.2758789062-6.9697265625,5.6630859375-8.2890625,2.7290039062-1.087890625,6.1479492188-.65625,8.5776367188,1.1689453125.2260742188.1708984375.359375.4375.3588867188.720703125,0,.283203125-.1337890625.5498046875-.3608398438.7197265625-1.0170898438.7607421875-1.814453125,1.7919921875-2.3012695312,2.9599609375,1.41015625.3642578125,2.9907226562.2734375,4.3383789062-.2666015625.2373046875-.0947265625.501953125-.0849609375.7333984375.029296875.228515625.11328125.3994140625.3193359375.4677734375.5654296875.2138671875.76953125.3232421875,1.57421875.3232421875,2.3916015625,0,2.8232421875-1.2978515625,5.41796875-3.5595703125,7.119140625-1.52734375,1.1484375-3.423828125,1.78125-5.3408203125,1.78125ZM11.2001953125,13.7003184301c-.9028320312,0-1.76953125.1630859375-2.576171875.4853515625-2.708984375,1.0546875-4.5239257812,3.7109375-4.5239257812,6.6142578125,0,3.9150390625,3.1850585938,7.099609375,7.1000976562,7.099609375,1.5517578125,0,3.0244140625-.490234375,4.2587890625-1.4189453125,1.8056640625-1.3583984375,2.8408203125-3.4287109375,2.8408203125-5.6806640625,0-.3310546875-.021484375-.6591796875-.0654296875-.982421875-1.7836914062.466796875-3.7680664062.3525390625-5.4790039062-.33203125-.4262695312-.1708984375-.6557617188-.6357421875-.5322265625-1.078125.41015625-1.470703125,1.2036132812-2.8193359375,2.2783203125-3.896484375-1.0102539062-.533203125-2.1337890625-.810546875-3.3012695312-.810546875Z"/>
				<g>
					<path class="cci-3" d="M18.9099731445,18.6500244141c-.8999633789.3599853516-1.8800048828.549987793-2.9099731445.549987793-1.0300292969,0-2.0100097656-.1900024414-2.9099731445-.549987793.4799804688-1.7200317383,1.5199584961-3.2100219727,2.9099731445-4.25,1.3900146484,1.049987793,2.4299926758,2.5299682617,2.9099731445,4.25Z"/>
					<path class="cci-3" d="M16,20.1007090551c-1.1328125,0-2.224609375-.20703125-3.2446289062-.615234375-.4262695312-.1708984375-.6557617188-.6357421875-.5322265625-1.078125.5244140625-1.8798828125,1.6743164062-3.55859375,3.2377929688-4.728515625.3203125-.240234375.76171875-.23828125,1.08203125.0029296875,1.564453125,1.1826171875,2.712890625,2.861328125,3.234375,4.7255859375.123046875.4423828125-.1064453125.9072265625-.533203125,1.078125-1.01953125.408203125-2.111328125.615234375-3.244140625.615234375ZM14.2377929688,18.0802012426c1.1328125.29296875,2.3920898438.29296875,3.5229492188,0-.3955078125-.9453125-1-1.806640625-1.7631835938-2.5107421875-.759765625.6982421875-1.36328125,1.5595703125-1.759765625,2.5107421875Z"/>
				</g>
				<path class="cci-3" d="M20.7998046875,29.7003184301c-1.93359375,0-3.779296875-.615234375-5.337890625-1.7783203125-2.2651367188-1.705078125-3.5620117188-4.2998046875-3.5620117188-7.1220703125,0-.8193359375.1083984375-1.6240234375.3232421875-2.392578125.068359375-.24609375.2387695312-.451171875.4677734375-.564453125.2294921875-.1142578125.4965820312-.1240234375.7333984375-.029296875,1.3471679688.5400390625,2.9287109375.630859375,4.3364257812.2666015625-.4853515625-1.1591796875-1.2836914062-2.19140625-2.3037109375-2.962890625-.2255859375-.1708984375-.3579101562-.4375-.3569335938-.720703125s.134765625-.548828125.3618164062-.71875c1.55859375-1.1630859375,3.404296875-1.7783203125,5.337890625-1.7783203125,1.1318359375,0,2.22265625.20703125,3.244140625.6142578125,3.4326171875,1.3359375,5.65625,4.58984375,5.65625,8.2861328125,0,4.9072265625-3.9931640625,8.900390625-8.900390625,8.900390625ZM13.765625,19.8175059301c-.0434570312.322265625-.0659179688.650390625-.0659179688.982421875,0,2.251953125,1.0356445312,4.322265625,2.8413085938,5.681640625,1.2431640625.9267578125,2.716796875,1.41796875,4.2587890625,1.41796875,3.9150390625,0,7.099609375-3.1845703125,7.099609375-7.099609375,0-2.9033203125-1.814453125-5.5595703125-4.515625-6.611328125-1.86328125-.7431640625-4.08203125-.6240234375-5.88671875.326171875,1.0771484375,1.083984375,1.8720703125,2.431640625,2.2802734375,3.892578125.123046875.4423828125-.1064453125.9072265625-.533203125,1.078125-1.7099609375.68359375-3.6953125.7978515625-5.478515625.33203125Z"/>
				</g>
			</svg>',

		'custom_css' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.cccssi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="cccssi-1" d="M10.9301757812,19.3681640625c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-4.935546875c0-.4970703125.4028320312-.8999023438.8999023438-.8999023438s.8999023438.4028320312.8999023438.8999023438v4.935546875c0,.4970703125-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="cccssi-1" d="M7.6000976562,16.8999023438h-2.8002929688c-.4970703125,0-.8999023438-.4028320312-.8999023438-.8999023438s.4028320312-.8999023438.8999023438-.8999023438h2.8002929688c.4970703125,0,.8999023438.4028320312.8999023438.8999023438s-.4028320312.8999023438-.8999023438.8999023438Z"/>
				<path class="cccssi-1" d="M27.2001953125,16.8999023438H10.9340820312c-.4970703125,0-.8999023438-.4028320312-.8999023438-.8999023438s.4028320312-.8999023438.8999023438-.8999023438h16.2661132812c.4970703125,0,.900390625.4028320312.900390625.8999023438s-.4033203125.8999023438-.900390625.8999023438Z"/>
				</g>
				<g>
				<path class="cccssi-1" d="M13.1728515625,29.7001953125h-4.0942382812c-.87890625,0-1.5942382812-.7158203125-1.5942382812-1.5947265625v-2.2255859375c0-.4970703125.4028320312-.900390625.8999023438-.900390625h1.4711914062v1.80078125h-.5712890625v1.119140625h3.6831054688v-5.103515625h-.8344726562v-1.80078125h1.734375c.4970703125,0,.8999023438.4033203125.8999023438.900390625v6.2099609375c0,.87890625-.7153320312,1.5947265625-1.5942382812,1.5947265625Z"/>
				<path class="cccssi-1" d="M22.921875,29.7001953125h-4.0947265625c-.87890625,0-1.5947265625-.7158203125-1.5947265625-1.5947265625v-1.1611328125h1.80078125v.955078125h3.681640625v-1.6513671875h-3.8876953125c-.87890625,0-1.5947265625-.7158203125-1.5947265625-1.5947265625v-2.0634765625c0-.87890625.7158203125-1.5947265625,1.5947265625-1.5947265625h4.0947265625c.87890625,0,1.59375.7158203125,1.59375,1.5947265625v1.158203125h-1.80078125v-.9521484375h-3.681640625v1.6513671875h3.888671875c.87890625,0,1.59375.7158203125,1.59375,1.5947265625v2.0634765625c0,.87890625-.71484375,1.5947265625-1.59375,1.5947265625Z"/>
				</g>
				<g>
				<path class="cccssi-1" d="M27.7958984375,11.00390625h-4.0947265625c-.87890625,0-1.5947265625-.71484375-1.5947265625-1.59375v-1.162109375h1.80078125v.9560546875h3.681640625v-1.6518554688h-3.8876953125c-.87890625,0-1.5947265625-.7153320312-1.5947265625-1.5942382812v-2.0639648438c0-.87890625.7158203125-1.59375,1.5947265625-1.59375h4.0947265625c.87890625,0,1.59375.71484375,1.59375,1.59375v1.158203125h-1.80078125v-.9521484375h-3.681640625v1.65234375h3.888671875c.87890625,0,1.59375.71484375,1.59375,1.59375v2.0639648438c0,.87890625-.71484375,1.59375-1.59375,1.59375Z"/>
				<path class="cccssi-1" d="M18.046875,11.00390625h-4.0942382812c-.87890625,0-1.59375-.71484375-1.59375-1.59375v-1.162109375h1.7998046875v.9560546875h3.6821289062v-1.6518554688h-3.8881835938c-.87890625,0-1.59375-.7153320312-1.59375-1.5942382812v-2.0639648438c0-.87890625.71484375-1.59375,1.59375-1.59375h4.0942382812c.87890625,0,1.5947265625.71484375,1.5947265625,1.59375v1.158203125h-1.80078125v-.9521484375h-3.6821289062v1.65234375h3.8881835938c.87890625,0,1.5947265625.71484375,1.5947265625,1.59375v2.0639648438c0,.87890625-.7158203125,1.59375-1.5947265625,1.59375Z"/>
				<path class="cccssi-1" d="M8.298828125,11.00390625h-4.0942382812c-.87890625,0-1.5942382812-.71484375-1.5942382812-1.59375V3.8940429688c0-.87890625.7153320312-1.59375,1.5942382812-1.59375h4.0942382812c.87890625,0,1.5942382812.71484375,1.5942382812,1.59375v1.158203125h-1.7998046875v-.9521484375h-3.6831054688v5.1040039062h3.6831054688v-.9560546875h1.7998046875v1.162109375c0,.87890625-.7153320312,1.59375-1.5942382812,1.59375Z"/>
				</g>
			</svg>',

		'pageSetting' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.ccpsi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="ccpsi-1" d="M13.7963867188,16.9191772113c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-3.671875c0-.4970703125.4028320312-.900390625.8999023438-.900390625s.8999023438.4033203125.8999023438.900390625v3.671875c0,.4970703125-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="ccpsi-1" d="M10.947265625,15.0832397113h-1.5551757812c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h1.5551757812c.4970703125,0,.8999023438.4033203125.8999023438.900390625s-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="ccpsi-1" d="M22.607421875,15.0832397113h-8.8090820312c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h8.8090820312c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="ccpsi-1" d="M17.4267578125,22.3234740863c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-3.671875c0-.4970703125.4028320312-.900390625.8999023438-.900390625s.900390625.4033203125.900390625.900390625v3.671875c0,.4970703125-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="ccpsi-1" d="M22.607421875,20.4875365863h-2.3310546875c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h2.3310546875c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="ccpsi-1" d="M17.4248046875,20.4875365863h-8.0327148438c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h8.0327148438c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				<path class="ccpsi-1" d="M24.001953125,29.7004272113H7.9985351562c-1.591796875,0-2.88671875-1.294921875-2.88671875-2.88671875V8.7521850238c0-.4970703125.4028320312-.900390625.8999023438-.900390625s.8999023438.4033203125.8999023438.900390625v18.0615234375c0,.5986328125.4877929688,1.0859375,1.0869140625,1.0859375h16.0034179688c.5986328125,0,1.0859375-.4873046875,1.0859375-1.0859375V5.1867553363c0-.5986328125-.4873046875-1.0859375-1.0859375-1.0859375h-12.4384765625c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h12.4384765625c1.591796875,0,2.88671875,1.294921875,2.88671875,2.88671875v21.626953125c0,1.591796875-1.294921875,2.88671875-2.88671875,2.88671875Z"/>
				<g>
				<path class="ccpsi-1" d="M6.0117834828,8.751758132h4.1321822113c.7840101322,0,1.4195759207-.6355657885,1.4195759207-1.4195759207V3.2l-5.551758132,5.551758132Z"/>
				<path class="ccpsi-1" d="M10.1440429688,9.6525756488h-4.1323242188c-.3637695312,0-.6923828125-.2197265625-.8315429688-.5556640625-.1391601562-.3369140625-.0620117188-.7236328125.1953125-.9814453125l5.5517578125-5.5517578125c.2578125-.2568359375.64453125-.3359375.98046875-.1943359375.3364257812.138671875.5556640625.466796875.5556640625.8310546875v4.1318359375c0,1.279296875-1.0405273438,2.3203125-2.3193359375,2.3203125ZM8.1845703125,7.8517943988h1.9594726562c.2866210938,0,.51953125-.232421875.51953125-.51953125v-1.958984375l-2.4790039062,2.478515625Z"/>
				</g>
			</svg>',

		'siteSetting' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.ccssi-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<g>
					<path class="ccssi-1" d="M11.654296875,17.6901404191c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-4.23046875c0-.4970703125.4028320312-.900390625.8999023438-.900390625s.8999023438.4033203125.8999023438.900390625v4.23046875c0,.4970703125-.4028320312.900390625-.8999023438.900390625Z"/>
					<path class="ccssi-1" d="M8.7998046875,15.5749060441h-2.3999023438c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h2.3999023438c.4970703125,0,.8999023438.4033203125.8999023438.900390625s-.4028320312.900390625-.8999023438.900390625Z"/>
					<path class="ccssi-1" d="M25.599609375,15.5749060441h-13.9418945312c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h13.9418945312c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				<g>
					<path class="ccssi-1" d="M20.345703125,23.3004919816c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625v-4.23046875c0-.4970703125.4033203125-.900390625.900390625-.900390625s.900390625.4033203125.900390625.900390625v4.23046875c0,.4970703125-.4033203125.900390625-.900390625.900390625Z"/>
					<path class="ccssi-1" d="M25.599609375,21.1852576066h-2.3994140625c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h2.3994140625c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
					<path class="ccssi-1" d="M20.341796875,21.1852576066H6.3999023438c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h13.9418945312c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				</g>
				<g>
				<path class="ccssi-1" d="M27.0029296875,29.6999060441H4.9970703125c-1.4868164062,0-2.6967773438-1.2099609375-2.6967773438-2.697265625V4.9967810441c0-1.4873046875,1.2099609375-2.697265625,2.6967773438-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9970703125,4.1002966691c-.4946289062,0-.8969726562.40234375-.8969726562.896484375v22.005859375c0,.494140625.40234375.896484375.8969726562.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9967810441c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9970703125Z"/>
				<path class="ccssi-1" d="M28.7998046875,7.3004919816H3.2001953125c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625s.4028320312-.900390625.8999023438-.900390625h25.599609375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="ccssi-1" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
				</g>
			</svg>',

		'siteLayout' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osls-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="osls-1" d="M27.0033074904,29.7003184301H4.9974481154c-1.4873046875,0-2.6982421875-1.2099609375-2.6982421875-2.697265625V4.9971934301c0-1.4873046875,1.2109375-2.697265625,2.6982421875-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9974481154,4.1007090551c-.4951171875,0-.8974609375.40234375-.8974609375.896484375v22.005859375c0,.494140625.40234375.896484375.8974609375.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9971934301c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9974481154Z"/>
				<path class="osls-1" d="M28.8001824904,7.2999278051H3.1995965529c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h25.6005859375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="osls-1" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
				</g>
				<path class="osls-1" d="M16.2025262404,23.2989512426H7.2542840529c-.9677734375,0-1.7548828125-.787109375-1.7548828125-1.7548828125v-11.08984375c0-.9677734375.787109375-1.7548828125,1.7548828125-1.7548828125h8.9482421875c.9677734375,0,1.7548828125.787109375,1.7548828125,1.7548828125v11.08984375c0,.9677734375-.787109375,1.7548828125-1.7548828125,1.7548828125ZM16.1566278029,10.4542246801l-8.90234375.0458984375.0458984375,11.0439453125,8.8564453125-.044921875v-11.044921875Z"/>
				<path class="osls-1" d="M24.7445184279,16.9005137426h-3.634765625c-.9677734375,0-1.7548828125-.787109375-1.7548828125-1.7548828125v-4.6943359375c0-.966796875.787109375-1.75390625,1.7548828125-1.75390625h3.634765625c.966796875,0,1.75390625.787109375,1.75390625,1.75390625v4.6943359375c0,.9677734375-.787109375,1.7548828125-1.75390625,1.7548828125ZM21.1097528029,10.4981699926l.0458984375,4.6474609375,3.5888671875-.0458984375-.0458984375-4.6015625h-3.5888671875ZM24.6976434279,10.4512949926v.0009765625-.0009765625Z"/>
				<path class="osls-1" d="M24.7445184279,26.4981699926h-3.634765625c-.9677734375,0-1.7548828125-.787109375-1.7548828125-1.7548828125v-4.689453125c0-.9677734375.787109375-1.7548828125,1.7548828125-1.7548828125h3.634765625c.966796875,0,1.75390625.787109375,1.75390625,1.7548828125v4.689453125c0,.9677734375-.787109375,1.7548828125-1.75390625,1.7548828125ZM21.1097528029,20.0997324926l.0458984375,4.6435546875,3.5888671875-.0458984375-.0458984375-4.59765625h-3.5888671875ZM24.6976434279,20.0538340551v.0009765625-.0009765625Z"/>
				<path class="osls-1" d="M17.0570184279,26.5001231176H6.3997918654c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h10.6572265625c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
			</svg>',

		'siteIcon' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osis-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="osis-1" d="M15.1605340529,29.6999060441c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625v-4.0302734375c0-.4970703125.4033203125-.900390625.900390625-.900390625s.900390625.4033203125.900390625.900390625v4.0302734375c0,.4970703125-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osis-1" d="M25.4857293654,27.6852576066h-7.5048828125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h7.5048828125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osis-1" d="M15.1566278029,27.6852576066H6.5140496779c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h8.642578125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				<g>
				<g>
					<rect class="osis-1" x="17.9309779916" y="3.2000000032" width="7.8958006491" height="7.8958006416" rx="3.9478963734" ry="3.9478963734"/>
					<path class="osis-1" d="M21.8792840529,11.9958044816c-2.6728515625,0-4.8486328125-2.1748046875-4.8486328125-4.84765625s2.17578125-4.8486328125,4.8486328125-4.8486328125,4.84765625,2.17578125,4.84765625,4.8486328125-2.1748046875,4.84765625-4.84765625,4.84765625ZM21.8792840529,4.1002966691c-1.6806640625,0-3.0478515625,1.3671875-3.0478515625,3.0478515625s1.3671875,3.046875,3.0478515625,3.046875,3.046875-1.3662109375,3.046875-3.046875-1.3662109375-3.0478515625-3.046875-3.0478515625Z"/>
				</g>
				<path class="osis-1" d="M25.8216668654,23.2243201066c-1.3701171875,0-2.720703125-.3203125-3.9375-.9287109375-1.21875.6083984375-2.5732421875.9287109375-3.9482421875.9287109375-.4970703125,0-.900390625-.4033203125-.900390625-.900390625,0-1.375.322265625-2.7255859375.935546875-3.9375-.61328125-1.212890625-.935546875-2.5673828125-.935546875-3.9482421875,0-.4970703125.4033203125-.900390625.900390625-.900390625,1.380859375,0,2.7353515625.322265625,3.9482421875.9345703125,1.2109375-.6123046875,2.5615234375-.9345703125,3.9375-.9345703125.4970703125,0,.900390625.4033203125.900390625.900390625,0,1.375-.3203125,2.7294921875-.9287109375,3.9482421875.6083984375,1.216796875.9287109375,2.5673828125.9287109375,3.9375,0,.4970703125-.4033203125.900390625-.900390625.900390625ZM21.8841668654,20.3747107316c.1552734375,0,.3095703125.0400390625.44921875.1201171875.7900390625.455078125,1.6357421875.744140625,2.5234375.8642578125-.1201171875-.8876953125-.4091796875-1.7333984375-.8642578125-2.5234375-.1591796875-.2783203125-.16015625-.6201171875,0-.8974609375.4482421875-.779296875.740234375-1.642578125.86328125-2.53515625-.890625.12109375-1.7333984375.4130859375-2.517578125.87109375-.28125.1640625-.626953125.1640625-.908203125,0-.7724609375-.451171875-1.6328125-.74609375-2.52734375-.8701171875.123046875.89453125.41796875,1.7548828125.8701171875,2.5283203125.1640625.2802734375.1640625.6279296875,0,.908203125-.458984375.7841796875-.7509765625,1.6279296875-.8720703125,2.517578125.892578125-.123046875,1.755859375-.4150390625,2.53515625-.86328125.138671875-.080078125.29296875-.1201171875.4482421875-.1201171875Z"/>
				<g>
					<path class="osis-1" d="M13.0355340529,11.9958044816h-5.8388671875c-1.060546875,0-1.923828125-.86328125-1.923828125-1.923828125v-5.8486328125c0-1.060546875.86328125-1.923828125,1.923828125-1.923828125h5.8388671875c1.060546875,0,1.923828125.86328125,1.923828125,1.923828125v5.8486328125c0,1.060546875-.86328125,1.923828125-1.923828125,1.923828125ZM7.1966668654,4.1002966691c-.068359375,0-.123046875.0546875-.123046875.123046875v5.8486328125c0,.068359375.0546875.123046875.123046875.123046875h5.8388671875c.068359375,0,.123046875-.0546875.123046875-.123046875v-5.8486328125c0-.068359375-.0546875-.123046875-.123046875-.123046875h-5.8388671875Z"/>
					<rect class="osis-1" x="8.5834655238" y="5.6153583081" width="3.0650840318" height="3.0650840318" rx=".3340395807" ry=".3340395807"/>
				</g>
				<g>
					<path class="osis-1" d="M10.2035028029,23.3004919816c-.23046875,0-.4609375-.087890625-.63671875-.263671875l-4.0302734375-4.0302734375c-.1689453125-.1689453125-.263671875-.3984375-.263671875-.6376953125.0009765625-.23828125.095703125-.4677734375.2646484375-.6357421875l4.0302734375-4.0205078125c.3515625-.3515625.9208984375-.3515625,1.2724609375,0l4.0302734375,4.0302734375c.1689453125.1689453125.263671875.3984375.263671875.6376953125-.0009765625.23828125-.095703125.4677734375-.2646484375.6357421875l-4.0302734375,4.0205078125c-.17578125.17578125-.40625.263671875-.6357421875.263671875ZM7.4466668654,18.3708044816l2.7578125,2.7568359375,2.755859375-2.7490234375-2.7578125-2.7568359375-2.755859375,2.7490234375Z"/>
					<polygon class="osis-1" points="10.2034620437 22.4 6.1732213607 18.3697593171 10.2034620437 14.34956501 10.2034620437 22.4"/>
				</g>
				</g>
			</svg>',

		'siteButton' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osbs-1 {
					letter-spacing: -.0059311em;
					}

					.osbs-2 {
					letter-spacing: -.0060690326em;
					}

					.osbs-3 {
					fill: #fff;
					font-family: MyriadPro-Regular, \'Myriad Pro\';
					font-size: 3.5399999619px;
					}

					.osbs-4 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<text class="osbs-3" transform="translate(.0004846144 -.7944763532)"><tspan x="0" y="0">Si</tspan><tspan class="osbs-2" x="2.5737304688" y="0">t</tspan><tspan x="3.7241210938" y="0">e But</tspan><tspan class="osbs-1" x="11.2885742188" y="0">t</tspan><tspan x="12.439453125" y="0">ons</tspan></text>
				<g>
				<path class="osbs-4" d="M17.8626824904,12.6447631488h-3.7255859375c-.7587890625,0-1.3759765625-.6171875-1.3759765625-1.3759765625v-1.107421875h1.80078125v.6826171875h2.8759765625v-1.1435546875h-3.30078125c-.7587890625,0-1.3759765625-.6171875-1.3759765625-1.3759765625v-1.9931640625c0-.7587890625.6171875-1.376953125,1.3759765625-1.376953125h3.7255859375c.7587890625,0,1.3759765625.6181640625,1.3759765625,1.376953125v1.103515625h-1.80078125v-.6796875h-2.8759765625v1.14453125h3.30078125c.7587890625,0,1.3759765625.6171875,1.3759765625,1.3759765625v1.9931640625c0,.7587890625-.6171875,1.3759765625-1.3759765625,1.3759765625Z"/>
				<path class="osbs-4" d="M26.7972528029,15.3000365863H5.2025262404c-1.6005859375,0-2.9033203125-1.3017578125-2.9033203125-2.90234375v-7.1953125c0-1.6005859375,1.302734375-2.90234375,2.9033203125-2.90234375h21.5947265625c1.6005859375,0,2.9033203125,1.3017578125,2.9033203125,2.90234375v7.1953125c0,1.6005859375-1.302734375,2.90234375-2.9033203125,2.90234375ZM5.2025262404,4.1008178363c-.6083984375,0-1.1025390625.494140625-1.1025390625,1.1015625v7.1953125c0,.607421875.494140625,1.1015625,1.1025390625,1.1015625h21.5947265625c.6083984375,0,1.1025390625-.494140625,1.1025390625-1.1015625v-7.1953125c0-.607421875-.494140625-1.1015625-1.1025390625-1.1015625H5.2025262404Z"/>
				<path class="osbs-4" d="M26.798473506,16.7034789691H5.1984368849c-1.5999755859,0-2.8999633789,1.299987793-2.8999633789,2.8999633789v7.1900024414c0,1.6000366211,1.299987793,2.9100341797,2.8999633789,2.9100341797h21.6000366211c1.5999755859,0,2.8999633789-1.3099975586,2.8999633789-2.9100341797v-7.1900024414c0-1.5999755859-1.299987793-2.8999633789-2.8999633789-2.8999633789ZM19.5084344435,21.6734496722h-1.799987793v-.8599853516h-3.4199829102v1.4899902344h3.7899780273c.7900390625,0,1.4299926758.6400146484,1.4299926758,1.4299926758v2.2200317383c0,.7899780273-.6399536133,1.4299926758-1.4299926758,1.4299926758h-4.1599731445c-.7899780273,0-1.4299926758-.6400146484-1.4299926758-1.4299926758v-1.2300415039h1.799987793v.8600463867h3.4199829102v-1.4800415039h-3.7899780273c-.7899780273,0-1.4299926758-.6499633789-1.4299926758-1.4299926758v-2.2299804688c0-.7900390625.6400146484-1.4299926758,1.4299926758-1.4299926758h4.1599731445c.7900390625,0,1.4299926758.6399536133,1.4299926758,1.4299926758v1.2299804688Z"/>
				</g>
			</svg>',

		'siteForm' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osfs-1 {
					letter-spacing: .0040000442em;
					}

					.osfs-2 {
					letter-spacing: -.0310348255em;
					}

					.osfs-3 {
					letter-spacing: -.0060690326em;
					}

					.osfs-4 {
					fill: #fff;
					font-family: MyriadPro-Regular, \'Myriad Pro\';
					font-size: 3.5399999619px;
					}

					.osfs-5 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<text class="osfs-4" transform="translate(.0001031447 -.7846510141)"><tspan x="0" y="0">Si</tspan><tspan class="osfs-3" x="2.5737304688" y="0">t</tspan><tspan x="3.7241210938" y="0">e </tspan><tspan class="osfs-2" x="6.248046875" y="0">F</tspan><tspan x="7.8623046875" y="0">o</tspan><tspan class="osfs-1" x="9.8056640625" y="0">r</tspan><tspan x="10.9775390625" y="0">ms</tspan></text>
				<g>
				<path class="osfs-5" d="M27.0033074904,29.7000291617H4.9974481154c-1.4873046875,0-2.6982421875-1.2099609375-2.6982421875-2.697265625V4.9969041617c0-1.4873046875,1.2109375-2.697265625,2.6982421875-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9974481154,4.1004197867c-.4951171875,0-.8974609375.40234375-.8974609375.896484375v22.005859375c0,.494140625.40234375.896484375.8974609375.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9969041617c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9974481154Z"/>
				<g>
					<path class="osfs-5" d="M8.1585809279,25.3289354117c-.3779296875,0-.7509765625-.1474609375-1.0361328125-.42578125-.4072265625-.3994140625-.5517578125-.984375-.3759765625-1.52734375l.7529296875-2.255859375c.2890625-.880859375.7939453125-1.6982421875,1.45703125-2.3623046875l11.2001953125-11.2001953125c.3515625-.3505859375.9208984375-.3515625,1.2724609375-.0009765625l3.01953125,3.0107421875c.1689453125.1689453125.263671875.3984375.2646484375.63671875,0,.2392578125-.0947265625.46875-.263671875.6376953125l-11.2001953125,11.19921875c-.65625.6572265625-1.4736328125,1.1611328125-2.3623046875,1.45703125l-2.25.75c-.15625.0546875-.3173828125.0810546875-.478515625.0810546875ZM8.0638543654,23.5418260367c-.0029296875.0009765625-.0048828125.001953125-.0068359375.0029296875l.0068359375-.0029296875ZM20.7943231154,9.4656541617l-10.564453125,10.5654296875c-.4658203125.46484375-.8193359375,1.037109375-1.0224609375,1.654296875l-.552734375,1.66015625,1.6640625-.5546875c.6240234375-.2080078125,1.197265625-.5615234375,1.6572265625-1.0224609375l10.5634765625-10.5625-1.7451171875-1.740234375Z"/>
					<g>
					<path class="osfs-5" d="M23.8130831979,11.2045010953l-3.0200195312-3.0100097656c.8300170898-.8300170898,2.1799926758-.8300170898,3.0100097656,0,.8300170898.8400268555.8300170898,2.1799926758.0100097656,3.0100097656Z"/>
					<path class="osfs-5" d="M23.8128778029,12.1053025992c-.23828125,0-.466796875-.0947265625-.6357421875-.2626953125l-3.01953125-3.0107421875c-.1689453125-.1689453125-.263671875-.3984375-.2646484375-.63671875,0-.2392578125.0947265625-.46875.263671875-.6376953125,1.142578125-1.142578125,3.140625-1.142578125,4.283203125,0,1.1708984375,1.1865234375,1.1748046875,3.1044921875.013671875,4.2802734375-.1689453125.169921875-.3974609375.2666015625-.6376953125.267578125h-.0029296875ZM22.3460809279,8.4715135367l1.1767578125,1.1728515625c-.015625-.296875-.1357421875-.58984375-.3603515625-.818359375-.224609375-.224609375-.5185546875-.3427734375-.81640625-.3544921875Z"/>
					</g>
					<path class="osfs-5" d="M12.9935418654,22.9246385367c-.2294921875,0-.4599609375-.087890625-.6357421875-.2626953125l-3.0205078125-3.009765625c-.3515625-.3505859375-.3525390625-.9208984375-.001953125-1.2734375.3505859375-.3505859375.9208984375-.3525390625,1.2734375-.001953125l3.0205078125,3.009765625c.3515625.3505859375.3525390625.9208984375.001953125,1.2734375-.17578125.17578125-.4072265625.2646484375-.6376953125.2646484375Z"/>
				</g>
				</g>
			</svg>',

		'siteScrollToTop' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osstts-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<polygon class="osstts-1" points="20.8003179413 17.1426543158 16.0003179413 12.3426543158 15.9996820587 12.3441905754 11.1996820587 17.1441905754 20.8003179413 17.1426543158"/>
				<path class="osstts-1" d="M11.1995965529,18.0442859925c-.3642578125,0-.6923828125-.2197265625-.8310546875-.5556640625-.1396484375-.3369140625-.0625-.7236328125.1943359375-.9814453125l4.7998046875-4.7998046875c.3515625-.3515625.921875-.3515625,1.2734375,0l4.80078125,4.798828125c.2568359375.2578125.333984375.64453125.1953125.9814453125-.1396484375.3359375-.4677734375.5556640625-.83203125.5556640625l-9.6005859375.0009765625ZM16.0003778029,13.615575055l-2.6279296875,2.6279296875h5.2548828125l-2.626953125-2.6279296875Z"/>
				</g>
				<path class="osstts-1" d="M27.0033074904,29.7005359925H4.9974481154c-1.4873046875,0-2.6982421875-1.2099609375-2.6982421875-2.697265625V4.9974109925c0-1.4873046875,1.2109375-2.6982421875,2.6982421875-2.6982421875h22.005859375c1.4873046875,0,2.697265625,1.2109375,2.697265625,2.6982421875v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9974481154,4.099950055c-.4951171875,0-.8974609375.40234375-.8974609375.8974609375v22.005859375c0,.494140625.40234375.896484375.8974609375.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9974109925c0-.4951171875-.40234375-.8974609375-.896484375-.8974609375H4.9974481154Z"/>
				<g>
				<path class="osstts-1" d="M20.1869012404,26.50034068c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625v-4.23046875c0-.4970703125.4033203125-.900390625.900390625-.900390625s.900390625.4033203125.900390625.900390625v4.23046875c0,.4970703125-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osstts-1" d="M25.2494012404,24.385106305h-2.3125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h2.3125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osstts-1" d="M20.1839715529,24.385106305H6.7513543654c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h13.4326171875c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
			</svg>',

		'sitePagination' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.osps-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="osps-1" d="M19.5990106154,14.8475415346h-7.1953125c-1.6005859375,0-2.90234375-1.3017578125-2.90234375-2.90234375v-7.1953125c0-1.6005859375,1.3017578125-2.90234375,2.90234375-2.90234375h7.1953125c1.6005859375,0,2.9033203125,1.3017578125,2.9033203125,2.90234375v7.1953125c0,1.6005859375-1.302734375,2.90234375-2.9033203125,2.90234375ZM12.4036981154,3.6483227846c-.607421875,0-1.1015625.494140625-1.1015625,1.1015625v7.1953125c0,.607421875.494140625,1.1015625,1.1015625,1.1015625h7.1953125c.6083984375,0,1.1025390625-.494140625,1.1025390625-1.1015625v-7.1953125c0-.607421875-.494140625-1.1015625-1.1025390625-1.1015625h-7.1953125Z"/>
				<path class="osps-1" d="M17.2464715529,12.3182446596h-1.80078125v-4.94921875l-1.19921875,1.2001953125-1.2734375-1.2734375,3.0439453125-3.0419921875.626953125.2099609375c.365234375.1494140625.6025390625.5009765625.6025390625.896484375v6.9580078125ZM16.8744012404,5.9412915346l-.013671875.013671875c.0048828125-.00390625.0087890625-.0087890625.013671875-.013671875Z"/>
				</g>
				<path class="osps-1" d="M19.5999755859,16.2523901521h-7.200012207c-1.5999755859,0-2.8999633789,1.299987793-2.8999633789,2.8999633789v7.1900024414c0,1.6000366211,1.299987793,2.9100341797,2.8999633789,2.9100341797h7.200012207c1.5999755859,0,2.9000244141-1.3099975586,2.9000244141-2.9100341797v-7.1900024414c0-1.5999755859-1.3000488281-2.8999633789-2.9000244141-2.8999633789ZM14.0815435838,22.5826196135l-1.2800292969-1.2700195312,2.848449092-2.7602221372c.299987793-.299987793.75-.3900146484,1.1400146484-.2300415039.4000244141.1600341797.6500244141.5400390625.6500244141.9700317383v7.8900146484h-1.8000488281v-6.0800170898l-1.5584100295,1.4802538755Z"/>
				<g>
				<path class="osps-1" d="M6.3997918654,9.2479321596h-3.2001953125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h3.2001953125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osps-1" d="M28.8001824904,9.2479321596h-3.2001953125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h3.2001953125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				</g>
				<path class="osps-1" d="M6.3997918654,23.6532055971h-3.2001953125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h3.2001953125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<path class="osps-1" d="M28.8001824904,23.6532055971h-3.2001953125c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h3.2001953125c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
			</svg>',

		'sitePage404' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.sp404s-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="sp404s-1" d="M27.0033074904,29.700246724H4.9974481154c-1.4873046875,0-2.6982421875-1.2099609375-2.6982421875-2.697265625V4.997121724c0-1.4873046875,1.2109375-2.697265625,2.6982421875-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.005859375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9974481154,4.100637349c-.4951171875,0-.8974609375.40234375-.8974609375.896484375v22.005859375c0,.494140625.40234375.896484375.8974609375.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.997121724c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9974481154Z"/>
				<path class="sp404s-1" d="M28.8001824904,7.3008326615H3.1995965529c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h25.6005859375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="sp404s-1" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
				</g>
				<g>
				<path class="sp404s-1" d="M17.8714715529,21.706106099h-3.63671875c-.7392578125,0-1.3408203125-.6025390625-1.3408203125-1.341796875v-6.12890625c0-.734375.6015625-1.33203125,1.3408203125-1.33203125h3.63671875c.7392578125,0,1.3408203125.59765625,1.3408203125,1.33203125v6.12890625c0,.7392578125-.6015625,1.341796875-1.3408203125,1.341796875ZM14.6947137404,19.905324849h2.716796875v-5.201171875h-2.716796875v5.201171875Z"/>
				<path class="sp404s-1" d="M11.2962762404,21.3965357865h-1.80078125v-1.7578125h-3.2060546875c-.4306640625,0-.8251953125-.25390625-1.00390625-.646484375-.1787109375-.3916015625-.1123046875-.8544921875.169921875-1.1806640625l3.900390625-4.525390625c.30859375-.35546875.7880859375-.4755859375,1.22265625-.3125.435546875.1630859375.7177734375.568359375.7177734375,1.0341796875v3.830078125h1.03125v1.80078125h-1.03125v1.7578125ZM6.8187371779,18.9863795365l-.001953125.0029296875c.0009765625-.0009765625.001953125-.001953125.001953125-.0029296875ZM7.8089715529,17.8379420365h1.6865234375v-1.95703125l-1.6865234375,1.95703125Z"/>
				<path class="sp404s-1" d="M25.8577996779,21.3965357865h-1.80078125v-1.7578125h-3.2060546875c-.4306640625,0-.8251953125-.25390625-1.00390625-.6455078125-.1796875-.392578125-.1123046875-.85546875.169921875-1.181640625l3.900390625-4.525390625c.3056640625-.3515625.7841796875-.4765625,1.220703125-.3134765625s.7197265625.5693359375.7197265625,1.03515625v3.830078125h1.03125v1.80078125h-1.03125v1.7578125ZM21.3802606154,18.9863795365l-.001953125.0029296875c.0009765625-.0009765625.001953125-.001953125.001953125-.0029296875ZM22.3704949904,17.8379420365h1.6865234375v-1.95703125l-1.6865234375,1.95703125Z"/>
				</g>
			</svg>',

		'sitePageSearchResult' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.spsrs-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<g>
				<path class="spsrs-1" d="M27.0033074904,29.7006591101H4.9974481154c-1.4873046875,0-2.6982421875-1.2099609375-2.6982421875-2.697265625V4.9965575476c0-1.4873046875,1.2109375-2.697265625,2.6982421875-2.697265625h22.005859375c1.4873046875,0,2.697265625,1.2099609375,2.697265625,2.697265625v22.0068359375c0,1.4873046875-1.2099609375,2.697265625-2.697265625,2.697265625ZM4.9974481154,4.1000731726c-.4951171875,0-.8974609375.40234375-.8974609375.896484375v22.0068359375c0,.494140625.40234375.896484375.8974609375.896484375h22.005859375c.494140625,0,.896484375-.40234375.896484375-.896484375V4.9965575476c0-.494140625-.40234375-.896484375-.896484375-.896484375H4.9974481154Z"/>
				<path class="spsrs-1" d="M28.8001824904,7.3002684851H3.1995965529c-.4970703125,0-.900390625-.4033203125-.900390625-.900390625s.4033203125-.900390625.900390625-.900390625h25.6005859375c.4970703125,0,.900390625.4033203125.900390625.900390625s-.4033203125.900390625-.900390625.900390625Z"/>
				<rect class="spsrs-1" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
				</g>
				<g>
				<path class="spsrs-1" d="M14.9369012404,23.7104247351c-3.955078125,0-7.1728515625-3.2177734375-7.1728515625-7.171875s3.2177734375-7.171875,7.1728515625-7.171875c3.9541015625,0,7.171875,3.2177734375,7.171875,7.171875s-3.2177734375,7.171875-7.171875,7.171875ZM14.9369012404,11.1674559851c-2.9619140625,0-5.3720703125,2.4091796875-5.3720703125,5.37109375s2.41015625,5.37109375,5.3720703125,5.37109375,5.37109375-2.4091796875,5.37109375-5.37109375-2.4091796875-5.37109375-5.37109375-5.37109375Z"/>
				<path class="spsrs-1" d="M23.3324090529,25.4330809851c-.1279296875,0-.255859375-.048828125-.353515625-.146484375l-3.9775390625-3.9765625c-.1953125-.1953125-.1953125-.51171875,0-.70703125s.51171875-.1953125.70703125,0l3.9775390625,3.9765625c.1953125.1953125.1953125.51171875,0,.70703125-.09765625.09765625-.2255859375.146484375-.353515625.146484375Z"/>
				<path class="spsrs-1" d="M23.3304559279,25.9330809851c-.255859375,0-.51171875-.09765625-.70703125-.29296875l-2.0703125-2.0703125c-.390625-.390625-.390625-1.0234375,0-1.4140625s1.0234375-.390625,1.4140625,0l2.0703125,2.0703125c.390625.390625.390625,1.0234375,0,1.4140625-.1953125.1953125-.451171875.29296875-.70703125.29296875Z"/>
				</g>
			</svg>',

		'footerCopyright' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.ofwc-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<path class="ofwc-1" d="M27.0026855469,2.2998046875H4.9968261719c-1.4868164062,0-2.6967773438,1.2099609375-2.6967773438,2.697265625v22.005859375c0,1.4873046875,1.2099609375,2.697265625,2.6967773438,2.697265625h22.005859375c1.4873046875,0,2.697265625-1.2099609375,2.697265625-2.697265625V4.9970703125c0-1.4873046875-1.2099609375-2.697265625-2.697265625-2.697265625ZM4.9968261719,27.8994140625c-.4946289062,0-.8969726562-.40234375-.8969726562-.896484375V4.9970703125c0-.494140625.40234375-.896484375.8969726562-.896484375h22.005859375c.494140625,0,.896484375.40234375.896484375.896484375v22.005859375c0,.494140625-.40234375.896484375-.896484375.896484375H4.9968261719Z"/>
				<path class="ofwc-1" d="M28.7995605469,23.9130859375H3.1999511719c-.4970703125,0-.8999023438.4033203125-.8999023438.900390625s.4028320312.900390625.8999023438.900390625h25.599609375c.4970703125,0,.900390625-.4033203125.900390625-.900390625s-.4033203125-.900390625-.900390625-.900390625Z"/>
				<path class="ofwc-1" d="M28.7995605469,19.927734375H3.1999511719c-.4970703125,0-.8999023438.4033203125-.8999023438.900390625s.4028320312.900390625.8999023438.900390625h25.599609375c.4970703125,0,.900390625-.4033203125.900390625-.900390625s-.4033203125-.900390625-.900390625-.900390625Z"/>
				<rect class="ofwc-1" x="3.2177097921" y="24.5852192344" width="25.5640921345" height="3.986044088"/>
			</svg>',

		'sidebar' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.osic-1 {
					fill: none;
				}

				.osic-1, .osic-2 {
					stroke: #000;
					stroke-linecap: round;
					stroke-linejoin: round;
					stroke-width: 1.8px;
				}

				.osic-2 {
					fill: #000;
				}
				</style>
			</defs>
			<path class="osic-2" d="M28.8025102525,4.997559641v22.0100097656c0,.9899902344-.8099975586,1.7899780273-1.799987793,1.7899780273h-6.1700439453V3.1975718481h6.1700439453c.9899902344,0,1.799987793.8099975586,1.799987793,1.799987793Z"/>
			<path class="osic-1" d="M20.8324785142,3.1975718481v25.5999755859H4.9925126939c-.9899902344,0-1.7900390625-.799987793-1.7900390625-1.7899780273V4.997559641c0-.9899902344.8000488281-1.799987793,1.7900390625-1.799987793h15.8399658203Z"/>
			</svg>',

		'footerWidget' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
				<defs>
				<style>
					.ofbcc-1 {
					stroke-width: 0px;
					}
				</style>
				</defs>
				<path class="ofbcc-1" d="M27.0026855469,2.2993164062H4.9968261719c-1.4868164062,0-2.6967773438,1.2099609375-2.6967773438,2.697265625v22.0068359375c0,1.4873046875,1.2099609375,2.697265625,2.6967773438,2.697265625h22.005859375c1.4873046875,0,2.697265625-1.2099609375,2.697265625-2.697265625V4.9965820312c0-1.4873046875-1.2099609375-2.697265625-2.697265625-2.697265625ZM4.9968261719,27.8999023438c-.4946289062,0-.8969726562-.40234375-.8969726562-.896484375V4.9965820312c0-.494140625.40234375-.896484375.8969726562-.896484375h22.005859375c.494140625,0,.896484375.40234375.896484375.896484375v22.0068359375c0,.494140625-.40234375.896484375-.896484375.896484375H4.9968261719Z"/>
				<path class="ofbcc-1" d="M28.7995605469,23.9135742188H3.1999511719c-.4970703125,0-.8999023438.4033203125-.8999023438.900390625s.4028320312.900390625.8999023438.900390625h25.599609375c.4970703125,0,.900390625-.4033203125.900390625-.900390625s-.4033203125-.900390625-.900390625-.900390625Z"/>
				<path class="ofbcc-1" d="M28.7995605469,19.9272460938H3.1999511719c-.4970703125,0-.8999023438.4033203125-.8999023438.900390625s.4028320312.900390625.8999023438.900390625h25.599609375c.4970703125,0,.900390625-.4033203125.900390625-.900390625s-.4033203125-.900390625-.900390625-.900390625Z"/>
				<rect class="ofbcc-1" x="3.2177097921" y="21.0936285892" width="25.5640921345" height="3.986044088"/>
			</svg>',

		'seo' => '
			<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.ossic-2 {
					fill: none;
					stroke: #000;
					stroke-linejoin: round;
					stroke-width: 1.8px;
				}
				</style>
			</defs>
			<g>
				<path class="ossic-2" d="M22.3926770206,16.0452978362v-3.7262856928c0-.4479786256.3631601266-.811112004.8111387522-.811112004h4.7850543911c.4479697095,0,.8111298361.3631333784.8111298361.811112004v7.4547469048c0,.4479786256-.3631601266.8111476682-.8111298361.8111476682h-4.7850543911c-.4479786256,0-.8111387522-.3631690426-.8111387522-.8111476682v-3.728461212Z"/>
				<line class="ossic-2" x1="17.3259450409" y1="16.0463961959" x2="13.2443511775" y2="16.0463979489"/>
				<path class="ossic-2" d="M19.6516732331,11.5078932152h-5.5961882087c-.4479768537,0-.8111338469.3631569932-.8111338469.8111338469v7.4547400206c0,.4479768537.3631569932.8111338469.8111338469.8111338469h4.7850543619l.8111338469.0000057869"/>
				<path class="ossic-2" d="M9.6073220556,13.6725573409v-1.3535302788c0-.4479768537-.3631569932-.8111338469-.8111338469-.8111338469h-4.7850543619c-.4479768537,0-.8111338469.3631569932-.8111338469.8111338469v2.9162370399c0,.4479769697.3631571743.811134011.811134144.8111338469l4.7850537676-.0000017529c.4479769697-.0000001641.811134144.3631568771.811134144.8111338469v2.9162370399c0,.4479768537-.3631569932.8111338469-.8111338469.8111338469h-4.7850543619c-.4479768537,0-.8111338469-.3631569932-.8111338469-.8111338469v-1.3579378364"/>
			</g>
			<g>
				<path class="ossic-2" d="M3.2,7.3898699113v-2.5419950024c0-.8844701883.7170047548-1.6014749431,1.601474943-1.6014749431h22.3970501139c.8844701883,0,1.601474943.7170047548,1.601474943,1.6014749431v2.5419950024"/>
				<path class="ossic-2" d="M3.2,24.6101300887v2.5419950024c0,.8844701883.7170047548,1.6014749431,1.601474943,1.6014749431h22.3970501139c.8844701883,0,1.601474943-.7170047548,1.601474943-1.6014749431v-2.5419950024"/>
			</g>
			</svg>',

		'performance' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.ospic-1 {
					fill: none;
					stroke: #000;
					stroke-linecap: round;
					stroke-linejoin: round;
					stroke-width: 1.8px;
				}

				.ospic-2 {
					fill: #000;
					stroke-width: 0px;
				}
				</style>
			</defs>
			<g>
				<rect class="ospic-1" x="3.2" y="3.2" width="25.6" height="25.6" rx="1.7969779753" ry="1.7969779753"/>
				<line class="ospic-1" x1="3.2" y1="6.4" x2="28.8" y2="6.4"/>
				<rect class="ospic-2" x="3.9265844537" y="3.9853366175" width="24.2944121393" height="2.3190331495"/>
			</g>
			<path class="ospic-2" d="M8.8168769187,15.1343617834l.8081259692.8081259692c.2183951961.2183951961.238938273.5552781044.0699194672.8137845195-.6736997639,1.0303925058-1.1064720699,2.2376388832-1.2119802115,3.5287406326-.0275629141.3372870196-.2989748948.6149485976-.6373862537.6149486608l-.9943376643-.0000005646c-.4968061301-.0000002935-.8023991316-.3064307485-.7779070201-.6722424299.1250927097-1.8683719596.7657623964-3.5901508845,1.7869026553-5.0302126273.2228084138-.3142152803.6842893885-.3355178297.956663058-.0631441602Z"/>
			<path class="ospic-2" d="M10.3323869319,12.7349317069c1.1630321779-.8057036477,2.4973833408-1.3720980303,3.9458272377-1.6255352337.3806458169-.0666023803.72430829.2451544994.72430829.6315831669v1.1595893968c0,.3113054847-.2281710686.5635738274-.5336334058.6236060305-.9512436874.1869469564-1.8372554011.5608914929-2.6196632526,1.0757029581-.2587069749.1702249237-.5961251385.1497673741-.8144668549-.0698521113l-.8057029828-.8104180794c-.2849503657-.2866179387-.2288969583-.7545214878.1033309684-.984676128Z"/>
			<path class="ospic-2" d="M21.7662841836,13.7261674751l-.805821499.805821499c-.2186010987.2186010987-.5555238216.238492283-.8135895385.0682719362-.7806541001-.514920049-1.6611611804-.8889634048-2.6107370842-1.0759890007-.3053931763-.0601493157-.5336136025-.3123398923-.5336136025-.6236001247v-1.1596704968c0-.3864361859.3436800217-.6982183688.724327198-.6315801444,1.4486049833.2536008931,2.7823953255.8209469553,3.9399919778,1.6324186635.3305451733.2317111542.3848809573.698889259.0994425484.9843276679Z"/>
			<path class="ospic-2" d="M25.9223312428,20.2376331401c.0237722205.3603905084-.2786668278.6623251592-.6398405215.6623263895l-1.1300048828.0000038493c-.3399658203,0-.6099853516-.2699584961-.6300048828-.6099853516-.1048571086-1.2845262478-.5380586565-2.4927106658-1.2195352601-3.5244868878-.1704632598-.2580865392-.1513815399-.59551734.0666874498-.8148625027l.8085048952-.8132363891c.2721084545-.2737008746.7347524306-.2529955338.9579208629.0618870325,1.0221734471,1.4422496717,1.6628285234,3.1669266794,1.7862723392,5.0383538598Z"/>
			<path class="ospic-2" d="M14.6715593248,20.0741710663l4.3582458496-4.3076410294c.1109989508-.1169679138.3168610734.0124819575.2597883969.1623475075.0000077457-.0000121117-1.9611586361,5.8054974556-1.9611586361,5.8054974556-1.0145192256,2.4443776466-4.4091594239.3234395081-2.6568756104-1.6602039337h0Z"/>
			</svg>',

		'preloader' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.osploaderic-1 {
					letter-spacing: -.0100690767em;
				}

				.osploaderic-2 {
					fill: none;
					stroke: #000;
					stroke-linecap: round;
					stroke-linejoin: round;
					stroke-width: 1.8px;
				}

				.osploaderic-3 {
					fill: #fff;
					font-family: MyriadPro-Regular, \'Myriad Pro\';
					font-size: 3.5399999619px;
				}

				.osploaderic-4 {
					letter-spacing: -.0160001767em;
				}
				</style>
			</defs>
			<text class="osploaderic-3" transform="translate(.0002581009 -.7857751779)"><tspan class="osploaderic-4" x="0" y="0">P</tspan><tspan class="osploaderic-1" x="1.8266601562" y="0">r</tspan><tspan x="2.9487304688" y="0">eloader</tspan></text>
			<g>
				<line class="osploaderic-2" x1="16.005" y1="7.78" x2="16.005" y2="3.2"/>
				<line class="osploaderic-2" x1="13.195" y1="8.27" x2="11.625" y2="3.98"/>
				<line class="osploaderic-2" x1="10.715" y1="9.7" x2="7.775" y2="6.2"/>
				<line class="osploaderic-2" x1="8.875" y1="11.89" x2="4.915" y2="9.6"/>
				<polyline class="osploaderic-2" points="7.905 14.57 3.405 13.78 3.395 13.78"/>
				<polyline class="osploaderic-2" points="7.895 17.43 3.405 18.23 3.395 18.23"/>
				<line class="osploaderic-2" x1="8.875" y1="20.11" x2="4.915" y2="22.4"/>
				<polyline class="osploaderic-2" points="10.715 22.3 7.775 25.8 7.775 25.81"/>
				<polyline class="osploaderic-2" points="11.625 28.03 13.185 23.74 13.195 23.74"/>
				<line class="osploaderic-2" x1="16.005" y1="28.8" x2="16.005" y2="24.23"/>
				<line class="osploaderic-2" x1="20.375" y1="28.03" x2="18.815" y2="23.73"/>
				<line class="osploaderic-2" x1="24.225" y1="25.81" x2="21.285" y2="22.3"/>
				<line class="osploaderic-2" x1="27.085" y1="22.4" x2="23.125" y2="20.11"/>
				<line class="osploaderic-2" x1="28.605" y1="18.23" x2="24.105" y2="17.43"/>
				<line class="osploaderic-2" x1="28.605" y1="13.78" x2="24.095" y2="14.57"/>
				<line class="osploaderic-2" x1="27.085" y1="9.6" x2="23.115" y2="11.89"/>
				<line class="osploaderic-2" x1="24.225" y1="6.2" x2="21.285" y2="9.7"/>
				<line class="osploaderic-2" x1="20.375" y1="3.98" x2="18.815" y2="8.28"/>
			</g>
			</svg>',

		'ecommerce' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.oecomic-1 {
					fill: none;
				}

				.oecomic-1, .oecomic-2 {
					stroke: #000;
					stroke-linecap: round;
					stroke-linejoin: round;
					stroke-width: 1.8px;
				}

				.oecomic-2 {
					fill: #000;
				}
				</style>
			</defs>
			<path class="oecomic-2" d="M28.8000183105,12.7000134277v12.1099853516c0,2.200012207-1.7900390625,3.9899902344-4,3.9899902344h-.799987793V11.2000134277h3.299987793c.8299560547,0,1.5.6699829102,1.5,1.5Z"/>
			<path class="oecomic-1" d="M24.0000305176,11.2000134277v17.5999755859H7.1999816895c-2.2099609375,0-4-1.7899780273-4-3.9899902344v-12.0999755859c0-.8300170898.6700439453-1.5100097656,1.5-1.5100097656h19.3000488281Z"/>
			<path class="oecomic-1" d="M7.6434860202,15.5612189588v-6.4026537075c0-1.5791050858.6272933048-3.0935095357,1.7438812569-4.2100966786,1.1165882218-1.1165893008,2.6310288168-1.743861566,4.2101333631-1.743861566,1.5791050858,0,3.0935807468.6272722652,4.2101689686,1.743861566,1.1165882218,1.1165871429,1.743860487,2.6309915928,1.743860487,4.2100966786v6.4026537075"/>
			<path class="oecomic-1" d="M13.6000036621,3.2000109863h4.44c1.58,0,3.1.63,4.21,1.75,1.12,1.12,1.75,2.63,1.75,4.21v2.04"/>
			</svg>',

		'customCode' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.ocodeic-1 {
					stroke-width: 0px;
				}
				</style>
			</defs>
			<g>
				<path class="ocodeic-1" d="M10.9301757812,19.3681640625c-.4970703125,0-.8999023438-.4033203125-.8999023438-.900390625v-4.935546875c0-.4970703125.4028320312-.8999023438.8999023438-.8999023438s.8999023438.4028320312.8999023438.8999023438v4.935546875c0,.4970703125-.4028320312.900390625-.8999023438.900390625Z"/>
				<path class="ocodeic-1" d="M7.6000976562,16.8999023438h-2.8002929688c-.4970703125,0-.8999023438-.4028320312-.8999023438-.8999023438s.4028320312-.8999023438.8999023438-.8999023438h2.8002929688c.4970703125,0,.8999023438.4028320312.8999023438.8999023438s-.4028320312.8999023438-.8999023438.8999023438Z"/>
				<path class="ocodeic-1" d="M27.2001953125,16.8999023438H10.9340820312c-.4970703125,0-.8999023438-.4028320312-.8999023438-.8999023438s.4028320312-.8999023438.8999023438-.8999023438h16.2661132812c.4970703125,0,.900390625.4028320312.900390625.8999023438s-.4033203125.8999023438-.900390625.8999023438Z"/>
			</g>
			<g>
				<path class="ocodeic-1" d="M13.1728515625,29.7001953125h-4.0942382812c-.87890625,0-1.5942382812-.7158203125-1.5942382812-1.5947265625v-2.2255859375c0-.4970703125.4028320312-.900390625.8999023438-.900390625h1.4711914062v1.80078125h-.5712890625v1.119140625h3.6831054688v-5.103515625h-.8344726562v-1.80078125h1.734375c.4970703125,0,.8999023438.4033203125.8999023438.900390625v6.2099609375c0,.87890625-.7153320312,1.5947265625-1.5942382812,1.5947265625Z"/>
				<path class="ocodeic-1" d="M22.921875,29.7001953125h-4.0947265625c-.87890625,0-1.5947265625-.7158203125-1.5947265625-1.5947265625v-1.1611328125h1.80078125v.955078125h3.681640625v-1.6513671875h-3.8876953125c-.87890625,0-1.5947265625-.7158203125-1.5947265625-1.5947265625v-2.0634765625c0-.87890625.7158203125-1.5947265625,1.5947265625-1.5947265625h4.0947265625c.87890625,0,1.59375.7158203125,1.59375,1.5947265625v1.158203125h-1.80078125v-.9521484375h-3.681640625v1.6513671875h3.888671875c.87890625,0,1.59375.7158203125,1.59375,1.5947265625v2.0634765625c0,.87890625-.71484375,1.5947265625-1.59375,1.5947265625Z"/>
			</g>
			<g>
				<path class="ocodeic-1" d="M27.7958984375,11.00390625h-4.0947265625c-.87890625,0-1.5947265625-.71484375-1.5947265625-1.59375v-1.162109375h1.80078125v.9560546875h3.681640625v-1.6518554688h-3.8876953125c-.87890625,0-1.5947265625-.7153320312-1.5947265625-1.5942382812v-2.0639648438c0-.87890625.7158203125-1.59375,1.5947265625-1.59375h4.0947265625c.87890625,0,1.59375.71484375,1.59375,1.59375v1.158203125h-1.80078125v-.9521484375h-3.681640625v1.65234375h3.888671875c.87890625,0,1.59375.71484375,1.59375,1.59375v2.0639648438c0,.87890625-.71484375,1.59375-1.59375,1.59375Z"/>
				<path class="ocodeic-1" d="M18.046875,11.00390625h-4.0942382812c-.87890625,0-1.59375-.71484375-1.59375-1.59375v-1.162109375h1.7998046875v.9560546875h3.6821289062v-1.6518554688h-3.8881835938c-.87890625,0-1.59375-.7153320312-1.59375-1.5942382812v-2.0639648438c0-.87890625.71484375-1.59375,1.59375-1.59375h4.0942382812c.87890625,0,1.5947265625.71484375,1.5947265625,1.59375v1.158203125h-1.80078125v-.9521484375h-3.6821289062v1.65234375h3.8881835938c.87890625,0,1.5947265625.71484375,1.5947265625,1.59375v2.0639648438c0,.87890625-.7158203125,1.59375-1.5947265625,1.59375Z"/>
				<path class="ocodeic-1" d="M8.298828125,11.00390625h-4.0942382812c-.87890625,0-1.5942382812-.71484375-1.5942382812-1.59375V3.8940429688c0-.87890625.7153320312-1.59375,1.5942382812-1.59375h4.0942382812c.87890625,0,1.5942382812.71484375,1.5942382812,1.59375v1.158203125h-1.7998046875v-.9521484375h-3.6831054688v5.1040039062h3.6831054688v-.9560546875h1.7998046875v1.162109375c0,.87890625-.7153320312,1.59375-1.5942382812,1.59375Z"/>
			</g>
			</svg>',

		'themeInfo' => '<svg id="Icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
			<defs>
				<style>
				.otiic-1 {
					fill: #000;
					stroke-width: 0px;
				}
				</style>
			</defs>
			<path class="otiic-1" d="M16.000386229,29.7000291617c-7.5546875,0-13.701171875-6.146484375-13.701171875-13.7001953125S8.445698729,2.2996385367,16.000386229,2.2996385367c7.5537109375,0,13.7001953125,6.146484375,13.7001953125,13.7001953125s-6.146484375,13.7001953125-13.7001953125,13.7001953125ZM16.000386229,4.1004197867c-6.5625,0-11.900390625,5.337890625-11.900390625,11.8994140625s5.337890625,11.8994140625,11.900390625,11.8994140625c6.5615234375,0,11.8994140625-5.337890625,11.8994140625-11.8994140625s-5.337890625-11.8994140625-11.8994140625-11.8994140625Z"/>
			<g>
				<path class="otiic-1" d="M16.000386229,24.4685838492c-.6630859375,0-1.2001953125-.537109375-1.2001953125-1.2001953125v-8.50390625c0-.6630859375.537109375-1.2001953125,1.2001953125-1.2001953125s1.2001953125.537109375,1.2001953125,1.2001953125v8.50390625c0,.6630859375-.537109375,1.2001953125-1.2001953125,1.2001953125Z"/>
				<circle class="otiic-1" cx="16" cy="10.3313297805" r="1.6"/>
			</g>
			</svg>'
	);

	return apply_filters( 'ocean_customizer_section_icons', $icons );
}
